function init () {
	renderer.shadowMapEnabled = true;
	renderer.shadowMapType = THREE.PCFSoftShadowMap;
	// Sounds
	scene = this;
	scene.listenerAudio = new THREE.AudioListener();
	scene.add( scene.listenerAudio );
	scene.sounds = {};
	scene.audioLoader = new THREE.AudioLoader();
	// Background 1
	scene.audioLoader.load( 'sounds/background1.mp3', function( buffer ) {
		scene.sounds['background1'] = buffer;
		scene.playSound('background1', 0.3, true);
	});
	// Sonido explosion
	scene.audioLoader.load( 'sounds/explosion.mp3', function( buffer ) {
		scene.sounds['explosion'] = buffer;
	});
	// Sonido corriendo
	scene.audioLoader.load( 'sounds/running.mp3', function( buffer ) {
		scene.sounds['running'] = buffer;
	});
	// Sonido tension
	scene.audioLoader.load( 'sounds/tension.mp3', function( buffer ) {
		scene.sounds['tension'] = buffer;
	});
	// Rebote
	scene.audioLoader.load( 'sounds/rebote.mp3', function( buffer ) {
		scene.sounds['rebote'] = buffer;
	});
	// Oh
	scene.audioLoader.load( 'sounds/oh.mp3', function( buffer ) {
		scene.sounds['oh'] = buffer;
	});
	// Latido 1
	scene.audioLoader.load( 'sounds/latido1.mp3', function( buffer ) {
		scene.sounds['latido1'] = buffer;
	});
	// Latido 2
	scene.audioLoader.load( 'sounds/latido2.mp3', function( buffer ) {
		scene.sounds['latido2'] = buffer;
	});
	// Music 1
	scene.audioLoader.load( 'sounds/music1.mp3', function( buffer ) {
		scene.sounds['music1'] = buffer;
	});
	// Funcion control sonidos
	scene.playSound = function (name, volume, loop = false) {
		if (this.sounds[name]) {
			if (!loop || !this.sounds[name+'_sound']) {
				let sound = new THREE.Audio( this.listenerAudio );
				sound.setBuffer(this.sounds[name]);
				sound.setLoop(loop);
				sound.setVolume(volume);
				sound.play();
				if (loop) this.sounds[name+'_sound'] = sound;
			} else {
				if (!this.sounds[name+'_sound'].isPlaying) {
					this.sounds[name+'_sound'].play();	
				}
				this.sounds[name+'_sound'].setVolume(volume);
			}
		}
	}
	// Funcion pause
	scene.pauseSound = function (name) {
		if (this.sounds[name+'_sound'] && this.sounds[name+'_sound'].isPlaying) {
			this.sounds[name+'_sound'].pause();
		}
	}
	// Funcion stop
	scene.stopSound = function (name) {
		if (this.sounds[name+'_sound'] && this.sounds[name+'_sound'].isPlaying) {
			this.sounds[name+'_sound'].stop();
		}
	}
}
function update () {}